webpackJsonp([0],{

/***/ 163:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2017 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Amounts = __webpack_require__(4);
const i18n = __webpack_require__(7);
const wire = __webpack_require__(164);
const wxApi_1 = __webpack_require__(2);
const renderHtml_1 = __webpack_require__(5);
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
class ReturnSelectionItem extends React.Component {
    constructor(props) {
        super(props);
        const exchange = this.props.exchangeUrl;
        const wireTypes = this.props.senderWireInfos.exchangeWireTypes;
        const supportedWires = this.props.senderWireInfos.senderWires.filter((x) => {
            return wireTypes[exchange] && wireTypes[exchange].indexOf(x.type) >= 0;
        });
        this.state = {
            currency: props.balance.byExchange[props.exchangeUrl].available.currency,
            selectedValue: Amounts.toFloat(props.balance.byExchange[props.exchangeUrl].available).toString(),
            selectedWire: "",
            supportedWires,
        };
    }
    render() {
        const exchange = this.props.exchangeUrl;
        const byExchange = this.props.balance.byExchange;
        const wireTypes = this.props.senderWireInfos.exchangeWireTypes;
        return (React.createElement("div", { key: exchange },
            React.createElement("h2", null,
                "Exchange ",
                exchange),
            React.createElement("p", null,
                "Available amount: ",
                renderHtml_1.renderAmount(byExchange[exchange].available)),
            React.createElement("p", null,
                "Supported wire methods: ",
                wireTypes[exchange].length ? wireTypes[exchange].join(", ") : "none"),
            React.createElement("p", null,
                "Wire ",
                "",
                React.createElement("input", { type: "text", size: this.state.selectedValue.length || 1, value: this.state.selectedValue, onChange: (evt) => this.setState({ selectedValue: evt.target.value }), style: { textAlign: "center" } }),
                " ",
                this.props.balance.byExchange[exchange].available.currency,
                " ",
                "",
                "to account ",
                "",
                React.createElement("select", { value: this.state.selectedWire, onChange: (evt) => this.setState({ selectedWire: evt.target.value }) },
                    React.createElement("option", { style: { display: "none" } }, "Select account"),
                    this.state.supportedWires.map((w, n) => React.createElement("option", { value: n.toString(), key: JSON.stringify(w) },
                        n + 1,
                        ": ",
                        wire.summarizeWire(w)))),
                "."),
            this.state.selectedWire
                ? React.createElement("button", { className: "pure-button button-success", onClick: () => this.select() }, i18n.str `Wire to bank account`)
                : null));
    }
    select() {
        let val;
        let selectedWire;
        try {
            val = Number.parseFloat(this.state.selectedValue);
            selectedWire = Number.parseInt(this.state.selectedWire);
        }
        catch (e) {
            console.error(e);
            return;
        }
        this.props.selectDetail({
            amount: Amounts.fromFloat(val, this.state.currency),
            exchange: this.props.exchangeUrl,
            senderWire: this.state.supportedWires[selectedWire],
        });
    }
}
class ReturnSelectionList extends React.Component {
    render() {
        const byExchange = this.props.balance.byExchange;
        const exchanges = Object.keys(byExchange);
        if (!exchanges.length) {
            return React.createElement("p", { className: "errorbox" }, "Currently no funds available to transfer.");
        }
        return (React.createElement("div", null, exchanges.map((e) => React.createElement(ReturnSelectionItem, Object.assign({ key: e, exchangeUrl: e }, this.props)))));
    }
}
class ReturnConfirmation extends React.Component {
    render() {
        return (React.createElement("div", null,
            React.createElement("p", null,
                "Please confirm if you want to transmit ",
                React.createElement("strong", null, renderHtml_1.renderAmount(this.props.detail.amount)),
                " at ",
                "",
                this.props.detail.exchange,
                " to account ",
                "",
                React.createElement("strong", { style: { whiteSpace: "nowrap" } }, wire.summarizeWire(this.props.detail.senderWire)),
                "."),
            React.createElement("button", { className: "pure-button button-success", onClick: () => this.props.confirm() }, i18n.str `Confirm`),
            React.createElement("button", { className: "pure-button", onClick: () => this.props.cancel() }, i18n.str `Cancel`)));
    }
}
class ReturnCoins extends React.Component {
    constructor(props) {
        super(props);
        const port = chrome.runtime.connect();
        port.onMessage.addListener((msg) => {
            if (msg.notify) {
                console.log("got notified");
                this.update();
            }
        });
        this.update();
        this.state = {};
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const balance = yield wxApi_1.getBalance();
            const senderWireInfos = yield wxApi_1.getSenderWireInfos();
            console.log("got swi", senderWireInfos);
            console.log("got bal", balance);
            this.setState({ balance, senderWireInfos });
        });
    }
    selectDetail(d) {
        this.setState({ selectedReturn: d });
    }
    confirm() {
        return __awaiter(this, void 0, void 0, function* () {
            const selectedReturn = this.state.selectedReturn;
            if (!selectedReturn) {
                return;
            }
            yield wxApi_1.returnCoins(selectedReturn);
            yield this.update();
            this.setState({ selectedReturn: undefined, lastConfirmedDetail: selectedReturn });
        });
    }
    cancel() {
        return __awaiter(this, void 0, void 0, function* () {
            this.setState({ selectedReturn: undefined, lastConfirmedDetail: undefined });
        });
    }
    render() {
        const balance = this.state.balance;
        const senderWireInfos = this.state.senderWireInfos;
        if (!balance || !senderWireInfos) {
            return React.createElement("span", null, "...");
        }
        if (this.state.selectedReturn) {
            return (React.createElement("div", { id: "main" },
                React.createElement(ReturnConfirmation, { detail: this.state.selectedReturn, cancel: () => this.cancel(), confirm: () => this.confirm() })));
        }
        return (React.createElement("div", { id: "main" },
            React.createElement("h1", null, "Wire electronic cash back to own bank account"),
            React.createElement("p", null, "You can send coins back into your own bank account.  Note that you're acting as a merchant when doing this, and thus the same fees apply."),
            this.state.lastConfirmedDetail
                ? React.createElement("p", { className: "okaybox" },
                    "Transfer of ",
                    renderHtml_1.renderAmount(this.state.lastConfirmedDetail.amount),
                    " successfully initiated.")
                : null,
            React.createElement(ReturnSelectionList, { selectDetail: (d) => this.selectDetail(d), balance: balance, senderWireInfos: senderWireInfos })));
    }
}
function main() {
    ReactDOM.render(React.createElement(ReturnCoins, null), document.getElementById("container"));
}
document.addEventListener("DOMContentLoaded", main);


/***/ }),

/***/ 164:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2017 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Display and manipulate wire information.
 *
 * Right now, all types are hard-coded.  In the future, there might be plugins / configurable
 * methods or support for the "payto://" URI scheme.
 */
/**
 * Imports.
 */
const i18n = __webpack_require__(7);
/**
 * Short summary of the wire information.
 *
 * Might abbreviate and return the same summary for different
 * wire details.
 */
function summarizeWire(w) {
    if (!w.type) {
        return i18n.str `Invalid Wire`;
    }
    switch (w.type.toLowerCase()) {
        case "test":
            if (!w.account_number && w.account_number !== 0) {
                return i18n.str `Invalid Test Wire Detail`;
            }
            if (!w.bank_uri) {
                return i18n.str `Invalid Test Wire Detail`;
            }
            return i18n.str `Test Wire Acct #${w.account_number} on ${w.bank_uri}`;
        default:
            return i18n.str `Unknown Wire Detail`;
    }
}
exports.summarizeWire = summarizeWire;


/***/ })

},[163]);
//# sourceMappingURL=return-coins-bundle.js.map