/* Copyright (C) 2001 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Martin Schwidefsky (schwidefsky@de.ibm.com).

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <ucontext.h>

extern int __getcontext (ucontext_t *__ucp) __THROW;
extern int __setcontext (__const ucontext_t *__ucp) __THROW;

int
__swapcontext (ucontext_t *oucp, const ucontext_t *ucp)
{
  /* Save the current machine context to oucp.  */
  __getcontext (oucp);
  /* Modify oucp to skip the __setcontext call on reactivation.  */
  oucp->uc_mcontext.gregs[14] = &&fake_return;
  /* Restore the machine context in ucp.  */
  __setcontext (ucp);

fake_return:
  return 0;
}

weak_alias (__swapcontext, swapcontext)
