;;; MovementPageBreak
(let ((tag "MovementPageBreak") 
	(params  MovementPageBreak::params)
	(Removed    (_ "Page Break Removed before Movement Title"))
	(Inserted  (_ "Page Break Inserted before Movement Title"))
	 (TitledPiece "TitledPiece"))
 (if (equal? params "edit")
 	(set! params #f))
 (if (eq? params #t) ;;; force a page break by deleting any existing one
 	(begin
 		(set! params #f)
 		(d-DirectiveDelete-movementcontrol tag)))
   (if (d-Directive-movementcontrol? TitledPiece)
	(let ((title (d-DirectiveGet-movementcontrol-data TitledPiece)))
		(if (not title)
			(set! title (d-DirectiveGet-movementcontrol-display TitledPiece)))
		 (d-DirectiveDelete-header tag)
		 (d-DirectiveDelete-movementcontrol TitledPiece) ;; to put page break before title
		 (if (d-Directive-movementcontrol? tag)
		  	(TimedNotice Removed)
		  	(TimedNotice Inserted))
		 (if (d-Directive-movementcontrol? tag)
		 	(d-DirectiveDelete-movementcontrol tag)
			(begin
			  (d-DirectivePut-movementcontrol-override tag (logior DENEMO_OVERRIDE_GRAPHIC DENEMO_OVERRIDE_TAGEDIT))
			  (d-DirectivePut-movementcontrol-display tag "Page Break before Movement")
			  (d-DirectivePut-movementcontrol-prefix  tag "\n\\pageBreak\n")))
		(d-DirectivePut-movementcontrol-display TitledPiece title)
		(d-DirectivePut-movementcontrol-data TitledPiece title)
		(d-DirectivePut-movementcontrol-prefix  TitledPiece (string-append "\\titledPiece \\markup \"" title "\"\n"))
		(d-DirectivePut-movementcontrol-override TitledPiece (logior DENEMO_OVERRIDE_TAGEDIT DENEMO_OVERRIDE_GRAPHIC)))
	(let ()
		(if (and (not params) (d-Directive-header? tag))
   			 (begin
   			 	(TimedNotice Removed)
   			 	(d-DirectiveDelete-header tag))
    			(begin
    				(TimedNotice Inserted)
				(d-DirectivePut-header-postfix tag "breakbefore = ##t\n")
				(d-DirectivePut-header-display tag (_ "(Page Break)"))
				(d-DirectivePut-header-override tag (logior DENEMO_OVERRIDE_GRAPHIC DENEMO_OVERRIDE_TAGEDIT))))))
   (d-SetSaved #f))
