'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" 
.so man.macros
.HS for tcl
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
for \- ``For'' loop
.SH SYNOPSIS
\fBfor \fIstart test next body\fR
.BE

.SH DESCRIPTION
.PP
\fBFor\fR is a looping command, similar in structure to the C
\fBfor\fR statement.  The \fIstart\fR, \fInext\fR, and
\fIbody\fR arguments must be Tcl command strings, and \fItest\fR
is an expression string.
The \fBfor\fR command first invokes the Tcl interpreter to
execute \fIstart\fR.  Then it repeatedly evaluates \fItest\fR as
an expression; if the result is non-zero it invokes the Tcl
interpreter on \fIbody\fR, then invokes the Tcl interpreter on \fInext\fR,
then repeats the loop.  The command terminates when \fItest\fR evaluates
to 0.  If a \fBcontinue\fR command is invoked within \fIbody\fR then
any remaining commands in the current execution of \fIbody\fR are skipped;
processing continues by invoking the Tcl interpreter on \fInext\fR, then
evaluating \fItest\fR, and so on.  If a \fBbreak\fR command is invoked
within \fIbody\fR
or \fInext\fR,
then the \fBfor\fR command will
return immediately.
The operation of \fBbreak\fR and \fBcontinue\fR are similar to the
corresponding statements in C.
\fBFor\fR returns an empty string.

.SH KEYWORDS
for, iteration, looping
